# Protocol buffers template

This project shows how to get started with protocol buffers.

It sets them up for Python, but this template can be adjusted to any language
supported by protocol buffers.


## [Protocol Buffers](https://protobuf.dev/) & [gRPC](https://grpc.io/)


Protocol buffers are "API definition files" that define the structure of our API. The protobuf files downloaded from [the developer platform](https://developer.audiotool.com/explore-protobufs) were placed into `/protos`.

The `.proto` files contain two things:

- **message definitions** which define structs of data
- **service definitions** which define a set of methods that can be called by your code, and execute on our server. Each method takes 1 message as input, and returns 1 message as output. Calling a method is called an "RPC", a remote procedure call, hence the name.


For example, the [ProjectService](./protos/audiotool/project/v1/project_service.proto) has a method `ListProject`, which lists projects of your user. It takes as an input the message `ListProjectRequest` (how many, what ordering?) and returns a `ListProjectResponse` (containing a list of `Project` messages).

To use these services, you have to generate code for your language of choice, which generates bindings based on the `.proto` files that you can then use in your code. 


In this example project, we generate bindings for Python.
In [main.py](./src/main.py), we then use these bindings to call
the method `ListProject` on `ProjectService`, and as a result, get a list of the projects of our user.


## Overview of Protobuf Setup

We utilize the [buf.build remote plugins](https://buf.build/docs/bsr/remote-plugins/) to generate code. 

* in [protos](./protos/), we pasted the protobuf files downloaded from the [dev page](https://developer.audiotool.com/explore-protobufs). In there you also find:
    * `buf.yaml`: general buf.build toolchain config
    * `buf.gen.yaml`: contains the links to the _Python code generators_, and the output directory to which the generated files should be written
    * `buf.lock`: a file generated by the buf CLI
* in the `src` directory, you find:
    * the generated files, in directory `audiotool`
    * the main file `main.py`, where we import the generated files
    * unrelated config files by uv


To run the generators, you need the [Buf CLI](https://buf.build/product/cli), then:
* `cd protos`
* `buf dep update`
* `buf generate .`


This will read the `buf*.yaml` files and generate code based on their content, i.e.:
* for Python
* placing the output into `../src`, resulting in the files in [./src/audiotool](./src/audiotool/).


## Using a different language than Python


To use a different language:
* delete the `src` directory
* update the generators listed in [buf.gen.yaml](./protos/buf.gen.yaml) to those for your language of choice. Currently there are 3 in there; you can remove them all and add those for your language of choice from the [buf.build plugins list](https://buf.build/plugins/protobuf).

LLMs can be helpful to resolve issues.

## Updating the protocol buffers
If we release a new version of the protocol buffers, [download them again](https://developer.audiotool.com/explore-protobufs) and replace the files in `protos`, then run the generators again.

## Running this project

* add `AT_PAT` env var with a [PAT](https://developer.audiotool.com/personal-access-tokens)
* install [uv](https://docs.astral.sh/uv/)
* cd into `src`
* `uv sync`
* `uv run main.py`



## Authorization & URLs

All API calls should be made against `https://rpc.audiotool.com`.

To authorize your API calls with PATs, add the header:
```
Authorization: Bearer at_pat_...
```

To authorize with OAuth2, add the header:
```
Authorization: Bearer ory_at_...
```