# -*- coding: utf-8 -*-
# Generated by https://github.com/connectrpc/connect-python.  DO NOT EDIT!
# source: audiotool/application/v1/application_service.proto

from collections.abc import AsyncGenerator, AsyncIterator, Iterable, Iterator, Mapping
from typing import Protocol

from connectrpc.client import ConnectClient, ConnectClientSync
from connectrpc.code import Code
from connectrpc.errors import ConnectError
from connectrpc.interceptor import Interceptor, InterceptorSync
from connectrpc.method import IdempotencyLevel, MethodInfo
from connectrpc.request import Headers, RequestContext
from connectrpc.server import ConnectASGIApplication, ConnectWSGIApplication, Endpoint, EndpointSync
import audiotool.application.v1.application_service_pb2 as audiotool_dot_application_dot_v1_dot_application__service__pb2


class ApplicationService(Protocol):
    async def list_applications(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def get_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def create_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def update_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def delete_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")

    async def upload_logo(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class ApplicationServiceASGIApplication(ConnectASGIApplication[ApplicationService]):
    def __init__(self, service: ApplicationService | AsyncGenerator[ApplicationService], *, interceptors: Iterable[Interceptor]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            service=service,
            endpoints=lambda svc: {
                "/audiotool.application.v1.ApplicationService/ListApplications": Endpoint.unary(
                    method=MethodInfo(
                        name="ListApplications",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.list_applications,
                ),
                "/audiotool.application.v1.ApplicationService/GetApplication": Endpoint.unary(
                    method=MethodInfo(
                        name="GetApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.get_application,
                ),
                "/audiotool.application.v1.ApplicationService/CreateApplication": Endpoint.unary(
                    method=MethodInfo(
                        name="CreateApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.create_application,
                ),
                "/audiotool.application.v1.ApplicationService/UpdateApplication": Endpoint.unary(
                    method=MethodInfo(
                        name="UpdateApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.update_application,
                ),
                "/audiotool.application.v1.ApplicationService/DeleteApplication": Endpoint.unary(
                    method=MethodInfo(
                        name="DeleteApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.delete_application,
                ),
                "/audiotool.application.v1.ApplicationService/UploadLogo": Endpoint.unary(
                    method=MethodInfo(
                        name="UploadLogo",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=svc.upload_logo,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/audiotool.application.v1.ApplicationService"


class ApplicationServiceClient(ConnectClient):
    async def list_applications(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListApplications",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def get_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def create_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def update_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def delete_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeleteApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    async def upload_logo(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse:
        return await self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UploadLogo",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )


class ApplicationServiceSync(Protocol):
    def list_applications(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def get_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def create_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def update_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def delete_application(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")
    def upload_logo(self, request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest, ctx: RequestContext) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse:
        raise ConnectError(Code.UNIMPLEMENTED, "Not implemented")


class ApplicationServiceWSGIApplication(ConnectWSGIApplication):
    def __init__(self, service: ApplicationServiceSync, interceptors: Iterable[InterceptorSync]=(), read_max_bytes: int | None = None) -> None:
        super().__init__(
            endpoints={
                "/audiotool.application.v1.ApplicationService/ListApplications": EndpointSync.unary(
                    method=MethodInfo(
                        name="ListApplications",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.list_applications,
                ),
                "/audiotool.application.v1.ApplicationService/GetApplication": EndpointSync.unary(
                    method=MethodInfo(
                        name="GetApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.get_application,
                ),
                "/audiotool.application.v1.ApplicationService/CreateApplication": EndpointSync.unary(
                    method=MethodInfo(
                        name="CreateApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.create_application,
                ),
                "/audiotool.application.v1.ApplicationService/UpdateApplication": EndpointSync.unary(
                    method=MethodInfo(
                        name="UpdateApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.update_application,
                ),
                "/audiotool.application.v1.ApplicationService/DeleteApplication": EndpointSync.unary(
                    method=MethodInfo(
                        name="DeleteApplication",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.delete_application,
                ),
                "/audiotool.application.v1.ApplicationService/UploadLogo": EndpointSync.unary(
                    method=MethodInfo(
                        name="UploadLogo",
                        service_name="audiotool.application.v1.ApplicationService",
                        input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
                        output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse,
                        idempotency_level=IdempotencyLevel.UNKNOWN,
                    ),
                    function=service.upload_logo,
                ),
            },
            interceptors=interceptors,
            read_max_bytes=read_max_bytes,
        )

    @property
    def path(self) -> str:
        """Returns the URL path to mount the application to when serving multiple applications."""
        return "/audiotool.application.v1.ApplicationService"


class ApplicationServiceClientSync(ConnectClientSync):
    def list_applications(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="ListApplications",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.ListApplicationsResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def get_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="GetApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.GetApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def create_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="CreateApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.CreateApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def update_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UpdateApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UpdateApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def delete_application(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="DeleteApplication",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.DeleteApplicationResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )

    def upload_logo(
        self,
        request: audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
        *,
        headers: Headers | Mapping[str, str] | None = None,
        timeout_ms: int | None = None,
    ) -> audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse:
        return self.execute_unary(
            request=request,
            method=MethodInfo(
                name="UploadLogo",
                service_name="audiotool.application.v1.ApplicationService",
                input=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoRequest,
                output=audiotool_dot_application_dot_v1_dot_application__service__pb2.UploadLogoResponse,
                idempotency_level=IdempotencyLevel.UNKNOWN,
            ),
            headers=headers,
            timeout_ms=timeout_ms,
        )
